// ParallelPortDlg.cpp : implementation file
//



#include "stdafx.h"
#include "ParallelPort.h"
#include "ParallelPortDlg.h"
#include "conio.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define DATA 0x378
#define STATUS 0x379
#define CONTROL 0x37a


short _stdcall Inp32(short portaddr);
void _stdcall Out32(short portaddr, short datum);




/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About


class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CParallelPortDlg dialog

CParallelPortDlg::CParallelPortDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CParallelPortDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CParallelPortDlg)
	m_pin1 = FALSE;
	m_pin10 = FALSE;
	m_pin11 = FALSE;
	m_pin12 = FALSE;
	m_pin13 = FALSE;
	m_pin14 = FALSE;
	m_pin15 = FALSE;
	m_pin16 = FALSE;
	m_pin2 = FALSE;
	m_pin3 = FALSE;
	m_pin4 = FALSE;
	m_pin5 = FALSE;
	m_pin6 = FALSE;
	m_pin7 = FALSE;
	m_pin8 = FALSE;
	m_pin9 = FALSE;
	m_pin17 = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CParallelPortDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CParallelPortDlg)
	DDX_Check(pDX, IDC_Pin1, m_pin1);
	DDX_Check(pDX, IDC_Pin10, m_pin10);
	DDX_Check(pDX, IDC_Pin11, m_pin11);
	DDX_Check(pDX, IDC_Pin12, m_pin12);
	DDX_Check(pDX, IDC_Pin13, m_pin13);
	DDX_Check(pDX, IDC_Pin14, m_pin14);
	DDX_Check(pDX, IDC_Pin15, m_pin15);
	DDX_Check(pDX, IDC_Pin16, m_pin16);
	DDX_Check(pDX, IDC_Pin2, m_pin2);
	DDX_Check(pDX, IDC_Pin3, m_pin3);
	DDX_Check(pDX, IDC_Pin4, m_pin4);
	DDX_Check(pDX, IDC_Pin5, m_pin5);
	DDX_Check(pDX, IDC_Pin6, m_pin6);
	DDX_Check(pDX, IDC_Pin7, m_pin7);
	DDX_Check(pDX, IDC_Pin8, m_pin8);
	DDX_Check(pDX, IDC_Pin9, m_pin9);
	DDX_Check(pDX, IDC_Pin17, m_pin17);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CParallelPortDlg, CDialog)
	//{{AFX_MSG_MAP(CParallelPortDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()

	ON_BN_CLICKED(IDC_About, OnAbout)
	//}}AFX_MSG_MAP
	ON_COMMAND_RANGE(IDC_Pin2, IDC_Pin9, ChangePin)
	ON_COMMAND(IDC_Pin14,  ChangeControl)
	ON_COMMAND(IDC_Pin16,  ChangeControl)
	ON_COMMAND(IDC_Pin17,  ChangeControl)
	ON_COMMAND(IDC_Pin1,  ChangeControl)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CParallelPortDlg message handlers

BOOL CParallelPortDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	SetTimer(1,200,NULL);
	Out32(CONTROL, Inp32(CONTROL) & 0xDF);
	UpdatePins();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CParallelPortDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CParallelPortDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CParallelPortDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CParallelPortDlg::ChangePin(int pin)
{
	int data_register, new_register;

	UpdateData(TRUE);
	data_register=Inp32( DATA );
    new_register=0;
	if( m_pin2==TRUE ) new_register |= 0x01;
	if( m_pin3==TRUE ) new_register |= 0x02;
	if( m_pin4==TRUE ) new_register |= 0x04;
	if( m_pin5==TRUE ) new_register |= 0x08;
	if( m_pin6==TRUE ) new_register |= 0x10;
	if( m_pin7==TRUE ) new_register |= 0x20;
	if( m_pin8==TRUE ) new_register |= 0x40;
	if( m_pin9==TRUE ) new_register |= 0x80;

	Out32(DATA, new_register);   
}

void CParallelPortDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	int status_reg;
	status_reg=Inp32(STATUS);

	if((status_reg & 0x40)==0) m_pin10=0;
	   else m_pin10=2;

	if((status_reg & 0x80)==0) m_pin11=0;
	   else m_pin11=1;

	if((status_reg & 0x20)==0) m_pin12=0;
	   else m_pin12=1;

	if((status_reg & 0x10)==0) m_pin13=0;
	   else m_pin13=1;

	if((status_reg & 0x8)==0) m_pin15=0;
	   else m_pin15=1;
	
	UpdateData(FALSE);
	CDialog::OnTimer(nIDEvent);
}

void CParallelPortDlg::ChangeControl()
{
	int control_register, new_register;

	UpdateData(TRUE);

	control_register=Inp32( CONTROL );
	new_register=control_register;
 
	if( m_pin1== 0 ) new_register &= 0xFE;
	   else new_register |= 0x01; 
	if( m_pin14==0 ) new_register &= 0xFD;
	   else new_register |= 0x02; 
	if( m_pin16==0 ) new_register &= 0xFB;
	   else new_register |= 0x04; 
	if( m_pin17==0 ) new_register &= 0xF7;
	   else new_register |= 0x08; 

	Out32(CONTROL, new_register);   
}


void CParallelPortDlg::UpdatePins()
{
	int reg;
	reg=Inp32(STATUS);

	if((reg & 0x40)==0) m_pin10=0;
	   else m_pin10=1;

	if((reg & 0x80)==0) m_pin11=0;
	   else m_pin11=1;

	if((reg & 0x20)==0) m_pin12=0;
	   else m_pin12=1;

	if((reg & 0x10)==0) m_pin13=0;
	   else m_pin13=1;

	if((reg & 0x8)==0) m_pin15=0;
	   else m_pin15=1;

//////////
    reg=Inp32(DATA);

   	if((reg & 0x01)==0) m_pin2=0;
	   else m_pin2=1;

	if((reg & 0x02)==0) m_pin3=0;
	   else m_pin3=1;

	if((reg & 0x04)==0) m_pin4=0;
	   else m_pin4=1;

	if((reg & 0x08)==0) m_pin5=0;
	   else m_pin5=1;

	if((reg & 0x10)==0) m_pin6=0;
	   else m_pin6=1;

	if((reg & 0x20)==0) m_pin7=0;
	   else m_pin7=2;

	if((reg & 0x40)==0) m_pin8=0;
	   else m_pin8=1;

	if((reg & 0x80)==0) m_pin9=0;
	   else m_pin9=1;
//////	
	reg = Inp32(CONTROL);

	if((reg & 0x01)==0) m_pin1=0;
	   else m_pin1=1;
    
	if((reg & 0x02)==0) m_pin14=0;
	   else m_pin14=1;

	if((reg & 0x04)==0) m_pin16=0;
	   else m_pin16=1;

	if((reg & 0x08)==0) m_pin17=0;
	   else m_pin17=1;

		
	UpdateData(FALSE);

}



void CParallelPortDlg::OnAbout() 
{
	// TODO: Add your control notification handler code here
    CAboutDlg about;
	about.DoModal();
	
}
